<?php
include("db.php"); // Include your database connection

// Set content type to JSON
header('Content-Type: application/json');

// Check if the request method is POST
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Get the raw POST data
    $rawData = file_get_contents('php://input');

    // Decode the JSON input
    $data = json_decode($rawData, true);

    // Check for JSON decoding errors
    if (json_last_error() !== JSON_ERROR_NONE) {
        echo json_encode(['status' => 'error', 'message' => 'Invalid JSON input', 'error_detail' => json_last_error_msg()]);
        exit();
    }

    // Validate required fields
    if (!isset($data['variant_ID'])) {
        echo json_encode(['status' => 'error', 'message' => 'variant_ID is required']);
        exit();
    }

    // Assign and sanitize input data
    $variantId = intval($data['variant_ID']);
    $productId = isset($data['product_ID']) ? intval($data['product_ID']) : null;
    $color = isset($data['color']) ? $conn->real_escape_string($data['color']) : null;
    $size = isset($data['size']) ? $conn->real_escape_string($data['size']) : null;
    $stock = isset($data['stock']) ? intval($data['stock']) : null;

    // Build the update query dynamically
    $updateFields = [];
    if ($productId !== null) $updateFields[] = "Product_ID = '$productId'";
    if ($color !== null) $updateFields[] = "Color = '$color'";
    if ($size !== null) $updateFields[] = "Size = '$size'";
    if ($stock !== null) $updateFields[] = "Stock = '$stock'";

    // Check if there are fields to update
    if (empty($updateFields)) {
        echo json_encode(['status' => 'error', 'message' => 'No fields to update']);
        exit();
    }

    $updateFieldsString = implode(", ", $updateFields);
    $updateQuery = "UPDATE product_variants SET $updateFieldsString WHERE variant_ID = $variantId";

    // Execute the update query
    if ($conn->query($updateQuery) === TRUE) {
        if ($conn->affected_rows > 0) {
            echo json_encode(['status' => 'success', 'message' => 'variant updated successfully']);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'No changes made or variant not found']);
        }
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Failed to update variant', 'error_detail' => $conn->error]);
    }
} else {
    // Handle invalid request method
    echo json_encode(['status' => 'error', 'message' => 'Only POST method is allowed']);
}

$conn->close();
?>
